/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view.form;

import java.util.List;
import java.util.Random;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.jdom.Attribute;
import org.jdom.Element;

public class RepeatManager {
    public Element addParentRepeatAttributes(Element repeater, String parentRepeaterId, Integer repeatStart, Integer repeatMax) {
        repeater.setAttribute("id", parentRepeaterId);
        repeater.setAttribute("repeat-start", repeatStart.toString());
        repeater.setAttribute("repeat-max", repeatMax.toString());
        repeater.setAttribute("style", "");
        return repeater;
    }

    public Element addChildRepeatAttributes(Element repeater, String parentId, Integer itemId, String forcedInputNameIndex) {
        StringBuilder nameVal = new StringBuilder(parentId);
        if (forcedInputNameIndex == null || forcedInputNameIndex.length() < 1) {
            nameVal.append("_[").append(parentId).append("]input");
        } else {
            nameVal.append("_[").append(forcedInputNameIndex).append("]input");
        }
        if (itemId == 0) {
            Random rand = new Random();
            itemId = rand.nextInt(100000) + 1;
        }
        nameVal.append(itemId);
        List inputs = ClassCastHelper.asList((Object)repeater.getChildren("input"), Element.class);
        if (inputs.isEmpty()) {
            inputs = ClassCastHelper.asList((Object)repeater.getChildren("select"), Element.class);
        }
        if (inputs.isEmpty()) {
            inputs = ClassCastHelper.asList((Object)repeater.getChildren("textarea"), Element.class);
        }
        for (Element input : inputs) {
            Attribute attribute = input.getAttribute("type");
            if (attribute != null && attribute.getValue() != null && attribute.getValue().equalsIgnoreCase("hidden")) continue;
            if (input.getAttribute("name") != null) {
                input.removeAttribute("name");
            }
            input.setAttribute("name", nameVal.toString());
        }
        return repeater;
    }

    public static Element createrepeatButtonControl(String type, String templateName) {
        Element element = new Element("button");
        element.setAttribute("type", type);
        element.setAttribute("template", templateName);
        if (type != null && type.equalsIgnoreCase("remove")) {
            element.setAttribute("class", "button_remove");
        } else {
            element.setAttribute("class", "button_search");
            element.addContent(type);
        }
        return element;
    }
}

