/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.pform;

import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.akaza.openclinica.web.pform.EnketoCredentials;
import org.akaza.openclinica.web.pform.EnketoEditURLRequest;
import org.akaza.openclinica.web.pform.EnketoURLRequest;
import org.akaza.openclinica.web.pform.EnketoURLResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class EnketoAPI {
    private String enketoURL = null;
    private String token = null;
    private String ocURL = null;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public EnketoAPI(EnketoCredentials credentials) {
        this.enketoURL = credentials.getServerUrl();
        this.token = credentials.getApiKey();
        this.ocURL = credentials.getOcInstanceUrl();
    }

    public String getOfflineFormURL(String crfOID) throws Exception {
        if (this.enketoURL == null) {
            return "";
        }
        URL eURL = new URL(this.enketoURL + "/api/v2/survey/offline");
        EnketoURLResponse response = this.getURL(eURL, crfOID);
        if (response != null) {
            String myUrl = response.getOffline_url();
            if (this.enketoURL.toLowerCase().startsWith("https") && !myUrl.toLowerCase().startsWith("https")) {
                myUrl = myUrl.replaceFirst("http", "https");
            }
            return myUrl;
        }
        return "";
    }

    public String getFormURL(String crfOID) throws Exception {
        if (this.enketoURL == null) {
            return "";
        }
        URL eURL = new URL(this.enketoURL + "/api/v2/survey/iframe");
        EnketoURLResponse response = this.getURL(eURL, crfOID);
        if (response != null) {
            String myUrl = response.getIframe_url();
            if (this.enketoURL.toLowerCase().startsWith("https") && !myUrl.toLowerCase().startsWith("https")) {
                myUrl = myUrl.replaceFirst("http", "https");
            }
            return myUrl;
        }
        return "";
    }

    public String getFormPreviewURL(String crfOID) throws Exception {
        if (this.enketoURL == null) {
            return "";
        }
        URL eURL = new URL(this.enketoURL + "/api/v1/survey/preview");
        EnketoURLResponse response = this.getURL(eURL, crfOID);
        if (response != null) {
            return response.getPreview_url();
        }
        return "";
    }

    private EnketoURLResponse getURL(URL url, String crfOID) {
        try {
            String userPasswdCombo = new String(Base64.encodeBase64((byte[])(this.token + ":").getBytes()));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Authorization", "Basic " + userPasswdCombo);
            headers.add("Accept-Charset", "UTF-8");
            EnketoURLRequest body = new EnketoURLRequest(this.ocURL, crfOID);
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            RestTemplate rest = new RestTemplate();
            ResponseEntity response = rest.postForEntity(url.toString(), (Object)request, EnketoURLResponse.class, new Object[0]);
            if (response != null) {
                return (EnketoURLResponse)response.getBody();
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public EnketoURLResponse getEditURL(String crfOid, String instance, String ecid, String redirect) {
        if (this.enketoURL == null) {
            return null;
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            String hashString = ecid + "." + String.valueOf(cal.getTimeInMillis());
            MessageDigestPasswordEncoder encoder = new MessageDigestPasswordEncoder("SHA-256");
            String instanceId = encoder.encode((CharSequence)hashString);
            URL eURL = new URL(this.enketoURL + "/api/v1/instance/iframe");
            String userPasswdCombo = new String(Base64.encodeBase64((byte[])(this.token + ":").getBytes()));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Authorization", "Basic " + userPasswdCombo);
            headers.add("Accept-Charset", "UTF-8");
            EnketoEditURLRequest body = new EnketoEditURLRequest(this.ocURL, crfOid, instanceId, redirect, instance);
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            RestTemplate rest = new RestTemplate();
            ResponseEntity response = rest.postForEntity(eURL.toString(), (Object)request, EnketoURLResponse.class, new Object[0]);
            if (response != null) {
                return (EnketoURLResponse)response.getBody();
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }
}

