/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.table.sdv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.controller.helper.table.SDVToolbarSubject;
import org.akaza.openclinica.controller.helper.table.SubjectAggregateContainer;
import org.akaza.openclinica.dao.StudySubjectSDVFilter;
import org.akaza.openclinica.dao.StudySubjectSDVSort;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.akaza.openclinica.web.table.sdv.SdvStatusFilter;
import org.akaza.openclinica.web.table.sdv.SdvStatusMatcher;
import org.akaza.openclinica.web.table.sdv.SubjectIdSDVFactory;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.component.HtmlColumn;
import org.jmesa.view.html.component.HtmlRow;
import org.jmesa.view.html.component.HtmlTable;
import org.jmesa.view.html.toolbar.Toolbar;
import org.jmesa.web.WebContext;

public class SubjectIdSDVFactory
extends AbstractTableFactory {
    private DataSource dataSource;
    private int studyId;
    private String contextPath;
    private ResourceBundle resword;
    private static final String ICON_FORCRFSTATUS_SUFFIX = ".gif'/>";
    public boolean showMoreLink;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected String getTableName() {
        return "s_sdv";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new SubjectSDVView(this, this.getLocale()));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"sdvStatus", "studySubjectId", "siteId", "personId", "studySubjectStatus", "group", "numberCRFComplete", "numberOfCRFsSDV", "totalEventCRF", "actions"});
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        Row row = tableFacade.getTable().getRow();
        SDVUtil sdvUtil = new SDVUtil();
        String[] allTitles = new String[]{this.resword.getString("SDV_status"), this.resword.getString("study_subject_ID"), this.resword.getString("site_id"), this.resword.getString("person_ID"), this.resword.getString("study_subject_status"), this.resword.getString("group"), this.resword.getString("num_CRFs_completed"), this.resword.getString("num_CRFs_SDV"), this.resword.getString("total_events_CRF"), this.resword.getString("actions")};
        sdvUtil.setTitles(allTitles, (HtmlTable)tableFacade.getTable());
        sdvUtil.turnOffFilters(tableFacade, new String[]{"personId", "studySubjectStatus", "group", "numberCRFComplete", "numberOfCRFsSDV", "totalEventCRF", "actions"});
        sdvUtil.turnOffSorts(tableFacade, new String[]{"sdvStatus", "studySubjectId", "siteId", "personId", "studySubjectStatus", "group", "numberCRFComplete", "numberOfCRFsSDV", "totalEventCRF"});
        sdvUtil.setHtmlCellEditors(tableFacade, new String[]{"sdvStatus", "actions"}, false);
        HtmlColumn sdvStatus = ((HtmlRow)row).getColumn("sdvStatus");
        sdvStatus.getFilterRenderer().setFilterEditor((FilterEditor)new SdvStatusFilter());
        String actionsHeader = this.resword.getString("rule_actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn("actions"), actionsHeader, (CellEditor)sdvUtil.getCellEditorNoEscapes(), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "sdvStatus"), (FilterMatcher)new SdvStatusMatcher());
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        int totalRows;
        Limit limit = tableFacade.getLimit();
        StudySubjectSDVFilter studySubjectSDVFilter = this.getStudySubjectSDVFilter(limit);
        WebContext context = tableFacade.getWebContext();
        if (context != null) {
            this.studyId = Integer.parseInt(context.getParameter("studyId"));
            this.contextPath = context.getContextPath();
        }
        String restore = context.getRequestAttribute(limit.getId() + "_restore") + "";
        if (!limit.isComplete()) {
            totalRows = this.getTotalRowCount(studySubjectSDVFilter);
            tableFacade.setTotalRows(totalRows);
        } else if (restore != null && "true".equalsIgnoreCase(restore)) {
            totalRows = this.getTotalRowCount(studySubjectSDVFilter);
            int pageNum = limit.getRowSelect().getPage();
            int maxRows = limit.getRowSelect().getMaxRows();
            tableFacade.setMaxRows(maxRows);
            tableFacade.setTotalRows(totalRows);
            limit.getRowSelect().setPage(pageNum);
        }
        StudySubjectSDVSort studySubjectSDVSort = this.getStudySubjectSDVSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        Collection items = this.getFilteredItems(studySubjectSDVFilter, studySubjectSDVSort, rowStart, rowEnd);
        tableFacade.setItems(items);
    }

    protected StudySubjectSDVFilter getStudySubjectSDVFilter(Limit limit) {
        StudySubjectSDVFilter studySubjectSDVFilter = new StudySubjectSDVFilter();
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            studySubjectSDVFilter.addFilter(property, (Object)value);
        }
        return studySubjectSDVFilter;
    }

    public StudySubjectSDVFilter createStudySubjectSDVFilter(Limit limit) {
        return this.getStudySubjectSDVFilter(limit);
    }

    protected StudySubjectSDVSort getStudySubjectSDVSort(Limit limit) {
        StudySubjectSDVSort studySubjectSDVSort = new StudySubjectSDVSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            studySubjectSDVSort.addSort(property, order);
        }
        return studySubjectSDVSort;
    }

    public int getTotalRowCount(StudySubjectSDVFilter studySubjectSDVFilter) {
        StudySubjectDAO studySubDAO = new StudySubjectDAO(this.dataSource);
        return studySubDAO.countAllByStudySDV(this.studyId, this.studyId, studySubjectSDVFilter);
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        tableFacade.setToolbar((Toolbar)new SDVToolbarSubject(this.showMoreLink));
    }

    private Collection<SubjectAggregateContainer> getFilteredItems(StudySubjectSDVFilter filterSet, StudySubjectSDVSort sortSet, int rowStart, int rowEnd) {
        ArrayList<SubjectAggregateContainer> rows = new ArrayList<SubjectAggregateContainer>();
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.dataSource);
        ArrayList studySubjectBeans = studySubjectDAO.findAllByStudySDV(this.studyId, this.studyId, filterSet, sortSet, rowStart, rowEnd);
        SubjectAggregateContainer containerTmp = null;
        for (StudySubjectBean studSubjBean : studySubjectBeans) {
            containerTmp = this.getRow(studSubjBean);
            rows.add(containerTmp);
        }
        return rows;
    }

    String getIconForCrfStatusPrefix() {
        String prefix = "../";
        return "<img hspace='2' border='0'  title='SDV Complete' alt='SDV Status' src='" + prefix + "images/icon_";
    }

    private SubjectAggregateContainer getRow(StudySubjectBean studySubjectBean) {
        SubjectAggregateContainer row = new SubjectAggregateContainer();
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        StudyDAO studyDAO = new StudyDAO(this.dataSource);
        StudyGroupDAO studyGroupDAO = new StudyGroupDAO(this.dataSource);
        row.setStudySubjectId(studySubjectBean.getLabel());
        row.setPersonId(studySubjectBean.getUniqueIdentifier());
        row.setStudySubjectStatus(studySubjectBean.getStatus().getName());
        int numberEventCRFs = eventCRFDAO.countEventCRFsByStudySubject(studySubjectBean.getId(), studySubjectBean.getStudyId(), studySubjectBean.getStudyId());
        row.setTotalEventCRF(numberEventCRFs + "");
        StudyBean studyBean = studyDAO.findByPK(studySubjectBean.getStudyId());
        row.setSiteId(studyBean.getIdentifier());
        ArrayList eventCRFBeans = eventCRFDAO.getEventCRFsByStudySubject(studySubjectBean.getId(), studySubjectBean.getStudyId(), studySubjectBean.getStudyId());
        HashMap stats = this.getEventCRFStats((List)eventCRFBeans, studySubjectBean);
        row.setNumberCRFComplete(stats.get("numberOfCompletedEventCRFs") + "");
        row.setNumberOfCRFsSDV(stats.get("numberOfSDVdEventCRFs") + "");
        boolean studySubjectSDVd = (Integer)stats.get("areEventCRFsSDVd") != -1 && (Integer)stats.get("areEventCRFsSDVd") != 1;
        StringBuilder sdvStatus = new StringBuilder("");
        if ((Integer)stats.get("shouldDisplaySDVButton") == 0) {
            sdvStatus.append("");
        } else if (studySubjectSDVd) {
            sdvStatus.append("<center><a href='javascript:void(0)' onclick='prompt(document.sdvForm,");
            sdvStatus.append(studySubjectBean.getId());
            sdvStatus.append(")'>");
            sdvStatus.append(this.getIconForCrfStatusPrefix()).append("DoubleCheck").append(ICON_FORCRFSTATUS_SUFFIX).append("</a></center>");
        } else {
            sdvStatus.append("<center><input style='margin-right: 5px' type='checkbox' ").append("class='sdvCheck'").append(" name='").append("sdvCheck_").append(studySubjectBean.getId()).append("' /></center>");
        }
        row.setSdvStatus(sdvStatus.toString());
        ArrayList studyGroupBeans = studyGroupDAO.getGroupByStudySubject(studySubjectBean.getId(), studySubjectBean.getStudyId(), studySubjectBean.getStudyId());
        if (studyGroupBeans != null && !studyGroupBeans.isEmpty()) {
            row.setGroup(((StudyGroupBean)studyGroupBeans.get(0)).getName());
        }
        StringBuilder actions = new StringBuilder("<table><tr><td>");
        StringBuilder urlPrefix = new StringBuilder("<a href=\"");
        StringBuilder path = new StringBuilder(this.contextPath).append("/pages/viewAllSubjectSDVtmp?studyId=").append(this.studyId).append("&sdv_f_studySubjectId=");
        path.append(studySubjectBean.getLabel());
        urlPrefix.append((CharSequence)path).append("\">");
        actions.append((CharSequence)urlPrefix).append("<img src=\"../images/bt_View.gif\" border=\"0\" />").append("</a></td>");
        if (!studySubjectSDVd && (Integer)stats.get("shouldDisplaySDVButton") == 1) {
            StringBuilder jsCodeString = new StringBuilder("this.form.method='GET'; this.form.action='").append(this.contextPath).append("/pages/sdvStudySubject").append("';").append("this.form.theStudySubjectId.value='").append(studySubjectBean.getId()).append("';").append("this.form.submit();");
            if (!studyBean.getStatus().isLocked()) {
                actions.append("<td><input type=\"submit\" class=\"button\" value=\"SDV\" name=\"sdvSubmit\" ").append("onclick=\"").append(jsCodeString.toString()).append("\" /></td>");
            }
        } else if (!studySubjectSDVd) {
            actions.append("<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SDV N/A</td>");
        }
        actions.append("</tr></table>");
        row.setActions(actions.toString());
        return row;
    }

    private HashMap<String, Integer> getEventCRFStats(List<EventCRFBean> eventCRFBeans, StudySubjectBean studySubject) {
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.dataSource);
        EventDefinitionCRFDAO eventDefinitionCrfDAO = new EventDefinitionCRFDAO(this.dataSource);
        CRFDAO crfDAO = new CRFDAO(this.dataSource);
        StudyEventBean studyEventBean = null;
        Integer numberOfCompletedEventCRFs = 0;
        Integer numberOfSDVdEventCRFs = 0;
        Integer areEventCRFsSDVd = eventCRFBeans.size() > 0 ? 0 : -1;
        Boolean partialOrHundred = false;
        for (EventCRFBean eventBean : eventCRFBeans) {
            EventDefinitionCRFBean eventDefinitionCrf;
            Integer n;
            Integer n2;
            studyEventBean = studyEventDAO.findByPK(eventBean.getStudyEventId());
            CRFBean crfBean = crfDAO.findByVersionId(eventBean.getCRFVersionId());
            if (eventBean.getStatus() == Status.UNAVAILABLE || eventBean.getStatus() == Status.LOCKED) {
                n2 = numberOfCompletedEventCRFs;
                n = numberOfCompletedEventCRFs = Integer.valueOf(numberOfCompletedEventCRFs + 1);
            }
            if (eventBean.isSdvStatus()) {
                n2 = numberOfSDVdEventCRFs;
                n = numberOfSDVdEventCRFs = Integer.valueOf(numberOfSDVdEventCRFs + 1);
            }
            if ((eventDefinitionCrf = eventDefinitionCrfDAO.findByStudyEventDefinitionIdAndCRFIdAndStudyId(studyEventBean.getStudyEventDefinitionId(), crfBean.getId(), studySubject.getStudyId())).getId() == 0) {
                eventDefinitionCrf = eventDefinitionCrfDAO.findForStudyByStudyEventDefinitionIdAndCRFId(studyEventBean.getStudyEventDefinitionId(), crfBean.getId());
            }
            if (!(eventDefinitionCrf.getSourceDataVerification() != SourceDataVerification.AllREQUIRED && eventDefinitionCrf.getSourceDataVerification() != SourceDataVerification.PARTIALREQUIRED || eventBean.getStatus() != Status.UNAVAILABLE && eventBean.getStatus() != Status.LOCKED)) {
                partialOrHundred = true;
            }
            if (eventDefinitionCrf.getSourceDataVerification() != SourceDataVerification.AllREQUIRED && eventDefinitionCrf.getSourceDataVerification() != SourceDataVerification.PARTIALREQUIRED || eventBean.isSdvStatus() || eventBean.getStatus() != Status.UNAVAILABLE && eventBean.getStatus() != Status.LOCKED) continue;
            areEventCRFsSDVd = 1;
        }
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("numberOfCompletedEventCRFs", numberOfCompletedEventCRFs);
        stats.put("numberOfSDVdEventCRFs", numberOfSDVdEventCRFs);
        stats.put("areEventCRFsSDVd", partialOrHundred == false ? 1 : areEventCRFsSDVd);
        stats.put("shouldDisplaySDVButton", numberOfCompletedEventCRFs > 0 && partialOrHundred == true ? 1 : 0);
        return stats;
    }
}

