/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.filter;

import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.hibernate.AuditUserLoginDao;
import org.akaza.openclinica.dao.hibernate.ConfigurationDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.technicaladmin.AuditUserLoginBean;
import org.akaza.openclinica.domain.technicaladmin.LoginStatus;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.TextEscapeUtils;
import org.springframework.util.Assert;

public class OpenClinicaUsernamePasswordAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String SPRING_SECURITY_FORM_USERNAME_KEY = "j_username";
    public static final String SPRING_SECURITY_FORM_PASSWORD_KEY = "j_password";
    public static final String SPRING_SECURITY_LAST_USERNAME_KEY = "SPRING_SECURITY_LAST_USERNAME";
    private String usernameParameter = "j_username";
    private String passwordParameter = "j_password";
    private boolean postOnly = true;
    private AuditUserLoginDao auditUserLoginDao;
    private ConfigurationDao configurationDao;
    private UserAccountDAO userAccountDao;
    private DataSource dataSource;

    public OpenClinicaUsernamePasswordAuthenticationFilter() {
        super("/j_spring_security_check");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        username = username.trim();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        HttpSession session = request.getSession(false);
        if (session != null || this.getAllowSessionCreation()) {
            request.getSession().setAttribute(SPRING_SECURITY_LAST_USERNAME_KEY, (Object)TextEscapeUtils.escapeEntities((String)username));
        }
        this.setDetails(request, authRequest);
        Authentication authentication = null;
        UserAccountBean userAccountBean = null;
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        try {
            UserAccountBean eb = this.getUserAccountDao().findByUserName(username);
            userAccountBean = eb.getId() != 0 ? eb : null;
            authentication = this.getAuthenticationManager().authenticate((Authentication)authRequest);
            this.auditUserLogin(username, LoginStatus.SUCCESSFUL_LOGIN, userAccountBean);
            this.resetLockCounter(username, LoginStatus.SUCCESSFUL_LOGIN, userAccountBean);
        }
        catch (LockedException le) {
            this.auditUserLogin(username, LoginStatus.FAILED_LOGIN_LOCKED, userAccountBean);
            throw le;
        }
        catch (BadCredentialsException au) {
            this.auditUserLogin(username, LoginStatus.FAILED_LOGIN, userAccountBean);
            this.lockAccount(username, LoginStatus.FAILED_LOGIN, userAccountBean);
            throw au;
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        return authentication;
    }

    private void auditUserLogin(String username, LoginStatus loginStatus, UserAccountBean userAccount) {
        AuditUserLoginBean auditUserLogin = new AuditUserLoginBean();
        auditUserLogin.setUserName(username);
        auditUserLogin.setLoginStatus(loginStatus);
        auditUserLogin.setLoginAttemptDate(new Date());
        auditUserLogin.setUserAccountId(userAccount != null ? Integer.valueOf(userAccount.getId()) : null);
        this.getAuditUserLoginDao().saveOrUpdate((DomainObject)auditUserLogin);
    }

    private void resetLockCounter(String username, LoginStatus loginStatus, UserAccountBean userAccount) {
        if (userAccount != null) {
            this.getUserAccountDao().updateLockCounter(Integer.valueOf(userAccount.getId()), Integer.valueOf(0));
        }
    }

    private void lockAccount(String username, LoginStatus loginStatus, UserAccountBean userAccount) {
        Boolean lockFeatureActive = Boolean.valueOf(this.getConfigurationDao().findByKey("user.lock.switch").getValue());
        if (userAccount != null && lockFeatureActive.booleanValue()) {
            Integer count = userAccount.getLockCounter();
            String lockCountString = this.getConfigurationDao().findByKey("user.lock.allowedFailedConsecutiveLoginAttempts").getValue();
            Integer lockThreshold = Integer.valueOf(lockCountString);
            if (count < lockThreshold) {
                count = count + 1;
                this.getUserAccountDao().updateLockCounter(Integer.valueOf(userAccount.getId()), count);
            }
            if (count >= lockThreshold) {
                this.getUserAccountDao().lockUser(Integer.valueOf(userAccount.getId()));
            }
        }
    }

    protected String obtainPassword(HttpServletRequest request) {
        return request.getParameter(this.passwordParameter);
    }

    protected String obtainUsername(HttpServletRequest request) {
        return request.getParameter(this.usernameParameter);
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setUsernameParameter(String usernameParameter) {
        Assert.hasText((String)usernameParameter, (String)"Username parameter must not be empty or null");
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        Assert.hasText((String)passwordParameter, (String)"Password parameter must not be empty or null");
        this.passwordParameter = passwordParameter;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public final String getUsernameParameter() {
        return this.usernameParameter;
    }

    public final String getPasswordParameter() {
        return this.passwordParameter;
    }

    public AuditUserLoginDao getAuditUserLoginDao() {
        return this.auditUserLoginDao;
    }

    public void setAuditUserLoginDao(AuditUserLoginDao auditUserLoginDao) {
        this.auditUserLoginDao = auditUserLoginDao;
    }

    public ConfigurationDao getConfigurationDao() {
        return this.configurationDao;
    }

    public void setConfigurationDao(ConfigurationDao configurationDao) {
        this.configurationDao = configurationDao;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public UserAccountDAO getUserAccountDao() {
        return this.userAccountDao != null ? this.userAccountDao : new UserAccountDAO(this.dataSource);
    }
}

