/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.client;

import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.managestudy.SubjectTransferBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.service.subject.SubjectServiceInterface;
import org.springframework.util.xml.DomUtils;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapCreateSubject
extends WebServiceGatewaySupport
implements SubjectServiceInterface {
    private static final String NAMESPACE_URI = "http://openclinica.org/create-subject";

    public String createSubject(SubjectBean subjectBean, StudyBean studyBean, Date enrollmentDate, String secondaryId) {
        Element requestElement = this.prepareRequest(subjectBean, studyBean);
        DOMSource source = new DOMSource(requestElement);
        DOMResult result = new DOMResult();
        this.getWebServiceTemplate().sendSourceAndReceiveToResult((Source)source, (Result)result);
        return this.processResponse(result.getNode());
    }

    private Element prepareRequest(SubjectBean subjectBean, StudyBean studyBean) {
        Document document = this.getDocument();
        Element requestElement = document.createElementNS(NAMESPACE_URI, "createSubjectRequest");
        requestElement.appendChild(this.mapSubject(document, subjectBean));
        requestElement.appendChild(this.mapStudy(document, studyBean));
        return requestElement;
    }

    private Element mapSubject(Document document, SubjectBean subject) {
        Element subjectElement = document.createElementNS(NAMESPACE_URI, "subject");
        subjectElement.setAttribute("uniqueIdentifier", subject.getUniqueIdentifier());
        return subjectElement;
    }

    private Element mapStudy(Document document, StudyBean study) {
        Element subjectElement = document.createElementNS(NAMESPACE_URI, "study");
        subjectElement.setAttribute("identifier", study.getIdentifier());
        return subjectElement;
    }

    private Document getDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private String processResponse(Node node) {
        Element responseElement = (Element)node.getFirstChild();
        return this.mapRewardConfirmation(DomUtils.getChildElementByTagName((Element)responseElement, (String)"result"));
    }

    private String mapRewardConfirmation(Element confirmationElement) {
        String confirmationNumber = confirmationElement.getAttribute("success");
        return confirmationNumber;
    }

    public boolean validate(SubjectTransferBean subjectTransferBean) {
        return false;
    }

    public List<StudySubjectBean> getStudySubject(StudyBean study) {
        return null;
    }
}

