/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.validator;

import javax.sql.DataSource;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.ws.bean.BaseStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.BaseVSValidatorImplementation;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class StudyEventDefinitionRequestValidator
implements Validator {
    DataSource dataSource;
    StudyDAO studyDAO;
    StudySubjectDAO studySubjectDAO;
    StudyEventDefinitionDAO studyEventDefinitionDAO;
    UserAccountDAO userAccountDAO;
    BaseVSValidatorImplementation helper;

    public StudyEventDefinitionRequestValidator(DataSource dataSource) {
        this.dataSource = dataSource;
        this.helper = new BaseVSValidatorImplementation();
    }

    public boolean supports(Class clazz) {
        return BaseStudyDefinitionBean.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors e) {
        StudyBean site;
        StudyBean study;
        BaseStudyDefinitionBean studyEventDefinitionRequestBean = (BaseStudyDefinitionBean)obj;
        if (studyEventDefinitionRequestBean.getStudyUniqueId() == null && studyEventDefinitionRequestBean.getSiteUniqueId() == null) {
            e.reject("studyEventDefinitionRequestValidator.invalid_study_identifier");
            return;
        }
        if (studyEventDefinitionRequestBean.getStudyUniqueId() != null && (study = this.helper.verifyStudy(this.getStudyDAO(), studyEventDefinitionRequestBean.getStudyUniqueId(), null, e)) == null) {
            return;
        }
        if (studyEventDefinitionRequestBean.getSiteUniqueId() != null && (site = this.helper.verifySite(this.getStudyDAO(), studyEventDefinitionRequestBean.getStudyUniqueId(), studyEventDefinitionRequestBean.getSiteUniqueId(), null, e)) == null) {
            return;
        }
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO != null ? this.studyDAO : new StudyDAO(this.dataSource);
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO != null ? this.studySubjectDAO : new StudySubjectDAO(this.dataSource);
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDAO() {
        return this.studyEventDefinitionDAO != null ? this.studyEventDefinitionDAO : new StudyEventDefinitionDAO(this.dataSource);
    }

    public UserAccountDAO getUserAccountDAO() {
        return this.userAccountDAO != null ? this.userAccountDAO : new UserAccountDAO(this.dataSource);
    }
}

