/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.bind.JAXBElement;
import org.akaza.openclinica.service.subject.SubjectServiceInterface;
import org.openclinica.ws.crf.v1.CreateCrfResponse;
import org.openclinica.ws.crf.v1.CrfType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;

@Endpoint
public class CrfEndpoint {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String NAMESPACE_URI_V1 = "http://openclinica.org/ws/crf/v1";
    private final String SUCCESS_MESSAGE = "success";
    private String dateFormat;
    private Properties dataInfo;

    public CrfEndpoint(SubjectServiceInterface subjectService, DataSource dataSource) {
    }

    @PayloadRoot(localPart="createCrfRequest", namespace="http://openclinica.org/ws/crf/v1")
    public CreateCrfResponse store(JAXBElement<CrfType> requestElement) throws Exception {
        CrfType crf = (CrfType)requestElement.getValue();
        String filePathWithName = this.getDataInfo().getProperty("filePath") + "crf/original/" + crf.getFileName();
        try {
            FileOutputStream fstream = new FileOutputStream(filePathWithName);
            crf.getFile().writeTo((OutputStream)fstream);
            fstream.close();
        }
        catch (Exception fstream) {
            // empty catch block
        }
        CreateCrfResponse crfResponse = new CreateCrfResponse();
        crfResponse.setResult("success");
        crfResponse.setKey("test");
        return crfResponse;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(Properties dataInfo) {
        this.dataInfo = dataInfo;
    }
}

