/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws;

import java.util.Locale;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapMessage;

public class UserPermissionInterceptor
implements EndpointInterceptor {
    private final DataSource dataSource;

    public UserPermissionInterceptor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = null;
        username = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : principal.toString();
        UserAccountDAO userAccountDao = new UserAccountDAO(this.dataSource);
        UserAccountBean userAccountBean = userAccountDao.findByUserName(username);
        Boolean result = userAccountBean.getRunWebservices();
        if (!result.booleanValue()) {
            SoapBody response = ((SoapMessage)messageContext.getResponse()).getSoapBody();
            response.addClientOrSenderFault("Authorization is required to execute SOAP web services with this account.Please contact your administrator.", Locale.ENGLISH);
            return false;
        }
        return result;
    }

    public boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return true;
    }

    public void afterCompletion(MessageContext messageContext, Object o, Exception e) throws Exception {
    }
}

