/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.ws.validator;

import javax.sql.DataSource;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.ws.bean.BaseStudyDefinitionBean;
import org.akaza.openclinica.ws.validator.BaseVSValidatorImplementation;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class StudyMetadataRequestValidator
implements Validator {
    DataSource dataSource;
    StudyDAO studyDAO;
    StudySubjectDAO studySubjectDAO;
    StudyEventDefinitionDAO studyEventDefinitionDAO;
    UserAccountDAO userAccountDAO;
    BaseVSValidatorImplementation helper;

    public StudyMetadataRequestValidator(DataSource dataSource) {
        this.dataSource = dataSource;
        this.helper = new BaseVSValidatorImplementation();
    }

    public boolean supports(Class clazz) {
        return BaseStudyDefinitionBean.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors e) {
        StudyBean site;
        BaseStudyDefinitionBean studyMetadataRequest = (BaseStudyDefinitionBean)obj;
        if (studyMetadataRequest.getStudyUniqueId() == null) {
            e.reject("studyEventDefinitionRequestValidator.study_does_not_exist");
            return;
        }
        StudyBean study = this.helper.verifyStudy(this.getStudyDAO(), studyMetadataRequest.getStudyUniqueId(), null, e);
        if (study == null) {
            return;
        }
        int site_id = -1;
        if (studyMetadataRequest.getSiteUniqueId() != null && (site = this.helper.verifySite(this.getStudyDAO(), studyMetadataRequest.getStudyUniqueId(), studyMetadataRequest.getSiteUniqueId(), null, e)) != null) {
            site_id = site.getId();
        }
        this.helper.verifyUser(studyMetadataRequest.getUser(), this.getUserAccountDAO(), study.getId(), site_id, e);
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO != null ? this.studyDAO : new StudyDAO(this.dataSource);
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO != null ? this.studySubjectDAO : new StudySubjectDAO(this.dataSource);
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDAO() {
        return this.studyEventDefinitionDAO != null ? this.studyEventDefinitionDAO : new StudyEventDefinitionDAO(this.dataSource);
    }

    public UserAccountDAO getUserAccountDAO() {
        return this.userAccountDAO != null ? this.userAccountDAO : new UserAccountDAO(this.dataSource);
    }
}

